/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.horiz;

import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.stream.FcsControlClient;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;

public class HorizonPlugin
implements DiscoveryPlugin,
FcsEventListener {
    private static final String TRACE_MASKD = "XFCSHRZD";
    private static final String TRACE_MASKF = "XFCSHRZF";
    private static final String TRACE_MASKT = "XFCSHRZT";
    NamedTimer horizonTimer;

    public HorizonPlugin() {
        Trace.trace(TRACE_MASKT, "<> HorizonPlugin");
        this.horizonTimer = new NamedTimer(true, "FCS Horizon Discovery Plugin Timer");
        this.horizonTimer.schedule((TimerTask)new HorizonTask(), FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000 * 2));
    }

    public void fcsStateChanged(FcsEvent event) {
        if (event.getEventType() == 3 && event.getEventDetails() == 150) {
            this.horizonTimer.cancel();
        } else if (event.getEventType() == 3 && event.getEventDetails() == 151) {
            this.horizonTimer.schedule((TimerTask)new HorizonTask(), FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000 * 2));
        }
    }

    class HorizonTask
    extends TimerTask {
        HorizonTask() {
        }

        public void run() {
            Trace.trace(HorizonPlugin.TRACE_MASKF, " HorizonTask pops");
            Set knownMachines = FcsServer.getFcsServer().getMachineList();
            Iterator iterator = knownMachines.iterator();
            while (iterator.hasNext()) {
                MachineId nextId = (MachineId)iterator.next();
                FcsControlClient fcc = new FcsControlClient(nextId, "FcsControlCommandHorizon");
                fcc.run();
            }
        }

        public boolean cancel() {
            Trace.trace(HorizonPlugin.TRACE_MASKF, " HorizonTask canceled.");
            return super.cancel();
        }

        public void schedule(int delay) {
            Trace.trace(HorizonPlugin.TRACE_MASKF, " HorizonTask scheduling timer pop " + delay + "ms in future.");
            HorizonPlugin.this.horizonTimer.schedule((TimerTask)this, delay);
        }
    }
}

